#include <stdlib.h>
#include <time.h>
#include "base.h"


void randomize(){
	srand(time(NULL));
}

Uint16 rnd(Uint16 max){
	return rand() % max;
}

int str2num(Uint8 **str, Uint8 type){
	Int32 num=0,b=0;
	Uint8 *a = *str;
	switch(type){
	case UNSIGNED_DEC://DEC unsigned (x*:Hex)
		if(*a=='x'){a++;
			//HEX
			for(;ISHEXSTR(*a);a++){
				num *=0x10;
				if(*a>'9')num += (*a|0x20)-'a'+0x0a;
				else      num += *a-'0';
			}
		}else{
			//DEC
			for(;*a>='0'&&*a<='9';a++){
				num *=10;
				num += *a-'0';
			}
		}
		*str = a;
		return num;
		
	case UNSIGNED_HEX://HEX 1byte Limit
		for(b=0;ISHEXSTR(*a)&&b<2;a++,b++){
			num *=0x10;
			if(*a>'9')num += (*a|0x20)-'a'+0x0a;
			else      num += *a-'0';
		}
		*str = a;
		return num;

	case SIGNED_DEC://DEC signed (x*:Hex)
		if(*a=='-'){b=1;a++;}
		if(*a=='+'){b=0;a++;}
		if(*a=='x'){a++;
			//HEX
			for(;ISHEXSTR(*a);a++){
				num *=0x10;
				if(*a>'9')num += (*a|0x20)-'a'+0x0a;
				else		  num += *a-'0';
			}
		}else{
			//DEC
			for(;*a>='0'&&*a<='9';a++){
				num *=10;
				num += *a-'0';
			}
		}
		*str = a;
		if(b)num*=-1;
		return num;
	case UNSIGNED_HEXEX://HEX Unlimit
		for(;ISHEXSTR(*a);a++){
			num *=0x10;
			if(*a>'9')num += (*a|0x20)-'a'+0x0a;
			else      num += *a-'0';
		}
		*str = a;
		return num;

	}
}


Int32 str2len(Uint8 **str, Uint32 deflen, Uint32 tick){
	Int32 num=0, n=deflen, b=1, dec=1;
	while(b){
		switch(**str){
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'x'://length num
				n = str2num(str,UNSIGNED_DEC);
				if(n<1)n=1;
				else n = tick/n;
				num += n*dec;
				break;
			case '.'://dotted
				n >>= 1;(*str)++;
				if(b==1)num=deflen;
				num += n*dec;
				break;
			case '+'://ADD
				dec=1;(*str)++;
				break;
			case '-'://DEC
				dec=-1;(*str)++;
				break;
			case '^'://Tick Direct Set
				(*str)++;
				n = str2num(str,UNSIGNED_DEC);
				num += n*dec;
				break;
			default:
				if(b==1)num=deflen;
				b=-1;
				break;
		}
		b++;
	}
	return num;
}

Int32 divblend(Int32 *v, Uint32 len, Uint16 sdiv, Uint16 ediv){
	Int64 d=0;
	Int32 a,b,c;
	if(!len)return 0;
	if(len==1)return v[0];
	for(a=1;a<len-1;a++){
		d+=v[a];
	}
	if(sdiv>0xff)d+=v[0];
	else{
		b=v[0];
		d+=(b*sdiv)>>8;
	}	
	if(ediv>0xff)d+=v[len-1];
	else{
		b=v[len-1];
		d+=(b*ediv)>>8;
	}
	return (d*0x100)/(((len-2)*0x100+sdiv+ediv));
}


