#ifndef BASE_H
#define BASE_H 1

//-----------------------

//Linux 32bit
#define OS_LINUX32 0x0032

//Linux 64bit
#define OS_LINUX64 0x0064

//Windows 32bit
#define OS_WIN32   0xB50D

//Windows 64bit
#define OS_WIN64   0xB564

//PC-9801 16bit
#define OS_PC9801  0x9801

/*-----------------------
 * Please select Machine.
 *-----------------------*/
#define OSSEL OS_LINUX64
//-----------------------


#if OSSEL == OS_LINUX32
typedef char Int8;
typedef short Int16;
typedef int Int32;
typedef long Int64;
typedef unsigned char Uint8;
typedef unsigned short Uint16;
typedef unsigned int Uint32;
typedef unsigned long Int64;
#define POINTSIZE 4
#define DIRSTR '/'
#endif

#if OSSEL == OS_LINUX64
typedef char Int8;
typedef short Int16;
typedef int Int32;
typedef long Int64;
typedef unsigned char Uint8;
typedef unsigned short Uint16;
typedef unsigned int Uint32;
typedef unsigned long Uint64;
#define POINTSIZE 8
#define DIRSTR '/'
#endif

#if OSSEL == OS_WIN32
typedef char Int8;
typedef short Int16;
typedef int Int32;
typedef long Int64;
typedef unsigned char Uint8;
typedef unsigned short Uint16;
typedef unsigned int Uint32;
typedef unsigned long Uint64;
#define POINTSIZE 4
#define DIRSTR '\\'
#endif

#if OSSEL == OS_WIN64
typedef char Int8;
typedef short Int16;
typedef int Int32;
typedef long Int64;
typedef unsigned char Uint8;
typedef unsigned short Uint16;
typedef unsigned int Uint32;
typedef unsigned long Uint64;
#define POINTSIZE 8
#define DIRSTR '\\'
#endif

#if OSSEL == OS_PC9801
typedef char Int8;
typedef int Int16;
typedef long Int32;
typedef unsigned char Uint8;
typedef unsigned int Uint16;
typedef unsigned long Uint32;
#define POINTSIZE 4 //16bitSEG + 16bitADR
#define DIRSTR '\\'
#endif
/*
struct SoundGenerator{
	Uint16  chstart;
	Uint16  chmax;
	void*  (* f_init)  (struct SoundGenerator sg, Uint8* modstr, Uint32 v1, Uint32 v2);
	Uint8  (* f_free)   (void* o);
	Uint8  (* f_keyon)      (void* o, Uint8 ch, Uint8 note, Uint8 vol, Uint32 val);
	Uint8  (* f_keyoff)     (void* o, Uint8 ch, Uint8 note);
	Uint32 (* f_read)       (void* o, Uint8 ch, Uint32 key);
	Uint8  (* f_write)      (void* o, Uint8 ch, Uint32 key, Uint32 val);
	Uint8  (* f_writedat)   (void* o, Uint8 ch, Uint32 key, Uint8 *val, Uint32 size);
	Uint32 (* f_regread)    (void* o, Uint32 adr);
	Uint8  (* f_regwrite)   (void* o, Uint32 adr, Uint32 val);
	Uint8  (* f_regwritedat)(void* o, Uint32 adr, Uint8 *val, Uint32 size);
	Uint8  (* f_out)        (void* o, Uint32 *left, Uint32 *right);	
};
*/

enum{
	UNSIGNED_DEC,
	UNSIGNED_HEX,
	SIGNED_DEC,
	UNSIGNED_HEXEX,
};

#define ISHEXSTR(x) (x>='0'&&x<='9'||x>='a'&&x<='f'||x>='A'&&x<='F')
#define ISDECSTR(x) (x>='0'&&x<='9')


void randomize();
Uint16 rnd(Uint16 max);
int str2num(Uint8 **str, Uint8 type);
Int32 str2len(Uint8 **str, Uint32 deflen, Uint32 tick);
Int32 divblend(Int32 *v, Uint32 len, Uint16 sdiv, Uint16 ediv);





//OFGS3 Setting
#define NOTEMAX 128
#define NOTEMUL 1.059463




#endif
