#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <termios.h>

#include "console.h"



Uint8 getscreensize(){
	struct winsize w;
	if (ioctl(STDOUT_FILENO, TIOCGWINSZ, &w) == 0) {
		screen_x=w.ws_col;
		screen_y=w.ws_row;
		if(screen_x==screen_xb && screen_y==screen_yb){
			return 0;
		}else{
			screen_xb=screen_x;
			screen_yb=screen_y;
			return 1;
		}
	}else{
		return -1;
	}
}

void flush(){
	fflush(stdout);
}

void cursor(Uint8 v){
	if(v)printf("\e[?12l\E[?25h");
	else printf("\e[?25l");
}

void locate(Uint16 x, Uint16 y){
	printf("\e[%d;%dH",y+1,x+1);
}

void color(Int16 c, Int16 b){
	if(c<0);
	else if(c<8)  printf("\e[3%dm", c);
	else if(c<16) printf("\e[9%dm", c-8);
	else          printf("\e[38;5;%dm", c&0xff);
	if(b<0);
	else if(b<8)  printf("\e[4%dm", b);
	else if(b<16) printf("\e[10%dm", b-8);
	else          printf("\e[48;5;%dm", b&0xff);
}

void cls(Int16 c){
	color(-1,c);
	printf("\e[H\e[2J");
}

void con_reset(){
	printf("\e[0m\e[?12l\E[?25h\n");
}

void inkey_open(){
	struct termios tnew;
	if(inkeymode)return;
	tcgetattr(STDIN_FILENO, &termios_backup);
	tnew = termios_backup;
	tnew.c_lflag &= ~ICANON;
	tnew.c_lflag &= ~ECHO;
	//tnew.c_lflag &= ~ISIG; //^C
	tnew.c_cc[VMIN] = 0;
	tnew.c_cc[VTIME] = 0;
	tcsetattr(STDIN_FILENO, TCSANOW, &tnew);
	inkeymode = 1;
}
void inkey_close(){
	if(!inkeymode)return;
	while(inkey());
	tcsetattr(STDIN_FILENO, TCSANOW, &termios_backup);
	inkeymode = 0;
}
Uint32 inkey(){
	Uint32 c=0,r,v=0;
	r=read(STDIN_FILENO, &v, 1);
	if(!r)return 0;
	if(v!=0x1b) return v;
	c=v;
	r=read(STDIN_FILENO, &v, 1);
	if(!r) return c;
	c=(c<<8)|v;
	r=read(STDIN_FILENO, &v, 1);
	if(!r) return c;
	c=(c<<8)|v;
	return c;

}

void vsync(Uint32 w){
	flush();
	for(Uint32 a=0;a<w;a++)
		usleep(16777);
}

