/*
 * main.c
 * 
 * 2025 OffGao
 * 
 * 
 */


#include <stdio.h>
//#include <stdlib.h>
#include <string.h>
#include "console.h"
#include "pulseaudio.h"
#include "seq_simple.h"



#define FRQ 44100
#define DM 65536
#define TRM 19

int main(int argc, char **argv)
{
	Uint32 a=0,b,c,z,tpr;
	Uint8 data[DM];
	Uint8 *mdata;
	
	if(argc<2){
		puts("Beep Play Ver0.90  2025/11/19 OffGao");
		puts("");
		puts("[Command Usage]");
		printf(" %s \"MMLDataString\"\n", argv[0]);
		puts("");
		puts("[MML Usage]");
		puts(" c,d,e,f,g,a,b - Note");
		puts("             r - Rest");
		puts("            Note after + or - : semitone up / down");
		puts(" Note&Rest after number or '.': Set note length");
		puts("");
		puts("       < >   - octave down / up");
		puts("       o[n] *- Octave");
		puts("       l[n] *- default note Length");
		puts("       n[n] *- Note shift");
		puts("       q[n] *- gate time  Length - n(tick)");
		puts("       t[n] *- Tempo (All Tracks)");
		puts("       v[n] *- Volume (0-15)");
		puts("       @[n]  - envelope  0: Disable  1..n: Short..Long");
		puts(" [n .. / .. ] - LoopStart(n:Count(Optional)) / LoopOut / LoopEnd");
		puts("   Note&Note - Tie,Slur");
		puts("           ; - track end & next track separator");
		puts("   (*: If number before '+' add, Can relative specification)");
		puts("");
		puts("[Default Value]");
		puts(" o7 l8 n0 q0 t150 v8 @0");
		puts("");
		puts("[Example]");
		printf(" %s \"[3gabagr]\"\n", argv[0]);
		printf(" %s \"v14o6q2@30[3ggrgar/brn+-12]gr<crrrn0o7c8;r1..o5g;r1..o5e;r1..o4c\"\n", argv[0]);

		return 0;
	}
	
	if(seq_simple_init(FRQ, TRM)){
		printf("Driver Init Error\n");
		return 0;
	}

	mdata = argv[1];
	if(ISDECSTR(argv[1][0])||argv[1][0]=='-'){
		a=str2num(&mdata, SIGNED_DEC);
		mdata = argv[1];
		if(!a){
			mdata = "v12ec8";
		}else{
			mdata = "v12>>>e>b-4";
		}
	}
	if(!strcmp(argv[1],"s0")){
		mdata = "v12<g-";
	}
	if(!strcmp(argv[1],"s1")){
		mdata = "v10@70d>a<d>a<d>a3;v9@70<d>a<d>a<d>a3";
	}
	if(!strcmp(argv[1],"s2")){
		mdata = "t120v12l^1o6[15fr]r^30[110fr];v12l^1o5[15rc]r^30[110rc]";
	}
	if(!strcmp(argv[1],"s3")){
		mdata = "v10o4[30c48n+2];v10o4[30d48n+2]";
	}
	if(!strcmp(argv[1],"s4")){
		mdata = "v10o7[28c48n+-2];v10o7[30f50n+-2]";
	}
	if(!strcmp(argv[1],"s5")){
		mdata = "v11@40gegag<g4;v11r^2@20>gegag<g4";
	}
	if(!strcmp(argv[1],"s6")){
		mdata = "@35c+cc+c>f4;@25n-1>gbgbd4;@9<c+cc+c>f4;@9n-1gbgbd4;r4>>>d-;@50r4>>>>d-4";
	}
	if(!strcmp(argv[1],"s7")){
		mdata = "o5l23v8[8bn+1v+-1]v8[8bn+1v+-1]v8[8bn+2v+-1]v8[8bn+3v+-1]";
	}
	if(!strcmp(argv[1],"s8")){
		mdata = "o6l48[40af];v3r29o6l48[40af];v1r14o6l48[40af]";
	}
	if(!strcmp(argv[1],"s9")){
		mdata = "o8g2;o8e2;o8c2;o7g2;o7e2;o7c2;o6g2;o6e2;o6c2;n-4o7g2;n-4o7e2;n-4o7c2;n-4o6g2;n-4o6e2;n-4o6c2;n-4o5g2;n-4o5e2;n-4o5c2;o4e2";
	}
	if(!strcmp(argv[1],"s10")){
		//TEST300
		mdata = "t130q6o6[ce-rg<c4.crr>b-4+16b-gre-f4.frrc4+16c--crde-4.grrf4+16e-dr/fg2..]>b-<c1+8>r8.g1;o5v6r4[6g8e-][6a8e-][3a-8e-][3a-8d][3g8d][3g8d-][6g8e-][6a8e-][3a-8e-][3g8d][6g8e-]r8.d+1;o4v10@30fgrr[c8<c>rrccrde-8b-rrggre-f8<c>rrffrcf8<c>rrffrga-8<c>rre-a-re-/a-8<c>rrda-rdg8brrdg8dg8brre-frg]g8<f>rre-f8.[c8<c>rrcf8g]v16c8.v8@0c1;o5v8r4r8[gr2gr2ar2ar2a-r2/a-r2gr2gr2]c-r4.r8gr2gr4.r8.v7d1;o5v8[8r1+8]r4..v6c-1";
	}
	if(!strcmp(argv[1],"s11")){
		//03E
		mdata = "t120l8q3@299o6[g<cc>b4<c>g4.gfeagfc4de2.defgab<dc>b<c4>ag4fc4d/e4.&g4.]t110c2.n+3t120a<cc>b4<c>g4.gfefedc4de2.defgab<dc>b<c4>gt110agfc4dt85e2.; l8q3@80o3[c<<ee>>d<<ff>>e<<gg>>a<<aa>>f<<aa>>g<<gg>>c<<gg>>e<<gg>>d<<ff>>g<<gg>>e<<bb>>e-<<b+b+>>d<<aa>>/f<<ff>>c-<<gg>>g<<bb>>]g<<ff>>cegbgdn+3c<<ee>>d<<ff>>e<<gg>>a<<aa>>f<<aa>>g<<ff>>c<<gg>>e<<gg>>d<<ff>>e<<gg>>g<<bb>>g-<<b+b+>>fgagdfa b<c+@199a4.>; v7o5l4.[gab<c>ff<c>bab<gg->f/a<df>]dl8efde4.l8n+3l4.gab<cc>b<c>bab<ee-l8>c4>af4gb2.";
	}
	if(!strcmp(argv[1],"s12")){
		//TEST106
		mdata = "t150l32o5q4cdefgab-b<l16c4>a8.<cdrc4>l8a<c>b-afab-g4a4l16f8.agrl32agaal16b-r<crd2r4l32c-rcrdrer[l16f4a8.agr<c4>b-8a/rab-a8f8a8l32ab-agg4]araarrr>>ffrffrrr<<aaraarrr>ffrff; l16@20r4o4b+ab+a<f>a<fca+dacf>a<c>a<a>f<f>a<c>f<c>a<f>a<f>a<e>g<e>g<fdf>a<a>a<d>a<a>a<ceaeca>dgb<dgb<dgbr8.l32>defgaa+<cd[l16d>dfd<d>dfd<e>>a<<g>c/<c>c<e>c<f>>f<a+d<d>>a+<a+f<f>ca+g<e>>l32fgaa+<cd<]l32>ea<cea<ceal16[ffrffr8./d>dfb<ar8.]>aaraa; l16r4o3q4f8.c<cr>crfrl8f4cfab-b<c4>c4d<f<d>f>c<e<c>e>g2>g<rrrl16[b-8<<dr>>b-8<<dr>>a8<<er>>/a8<<gr>>g8<<fr>>g8<<dr>>b+8<<fr>>c8<<er>>]<c8<<cr>>>bbrbbr8.ggrggr8.<ccrccr8.>ccrcc";
	}
	if(seq_simple_read(mdata)){
		printf("Data Read Error\n");
		return 0;
	}
	
	//inkey_open();
	//printf("PA init\n");
	a=opa_open(FRQ,2);
	if(a){
		printf("PA ERR\n");
		return 0;
	}
	//cls(0);
	//locate(5,5);printf("TEST!!\n");

	z=0;
	while(z!=' '){
		//z=inkey();
		//if(z);
		
		if(!seq_simple_tick())break;
		
		tpr = seq_simple_tick_per_render()*2;
		if(tpr>DM)tpr=DM;
		for(b=0;b<tpr;b+=2){
			c=seq_simple_render();
			//printf("%04X,",c&0xffff);
			data[b+0]=c;
			data[b+1]=c>>8;
		}
		opa_write(data,tpr);
		//vsync(1);
	}
	//printf("PA end\n");
	opa_close();
	//inkey_close();
	seq_simple_free();
	return 0;
}

