#include <pulse/error.h>
#include <pulse/simple.h>
#include <pulse/stream.h>

#include "pulseaudio.h"

pa_simple *pa = NULL;

Uint8 opa_open(Uint32 frq, Uint8 format){
	pa_sample_spec ss;
	int err;
	
	if(pa)return 1;
	
	ss.rate = frq;
	switch(format){
	case 0://8bit 1ch
		ss.format = PA_SAMPLE_U8;
		ss.channels = 1;break;
	case 1://8bit 2ch
		ss.format = PA_SAMPLE_U8;
		ss.channels = 2;break;
	case 2://16bit 1ch
		ss.format = PA_SAMPLE_S16LE;
		ss.channels = 1;break;
	case 3://16bit 2ch
		ss.format = PA_SAMPLE_S16LE;
		ss.channels = 2;break;
	}

	pa = pa_simple_new(
			NULL,               // Use the default server.
			"OFGS3",            // Our application's name.
			PA_STREAM_PLAYBACK,
			NULL,
			"Stream Playback",     // Description of our stream.
			&ss,                // Our sample format.
			NULL,               // Use default channel map
			NULL,               // Use default buffering attributes.
			&err                // Ignore error code.
	);
	if(!pa)return 1;
	return 0;
}

Uint8 opa_write(Uint8 *d, Uint32 l){
	Int32 ret,err;
	if(!pa)return 1;
	
	ret = pa_simple_write(pa, d, l, &err);
	if(ret<0)return 1;
	return 0;
}

void opa_wait(){
	if(!pa)return;
	pa_simple_drain(pa, NULL);	
}

Uint8 opa_close(){
	if(!pa)return 1;
	pa_simple_drain(pa, NULL);
	pa_simple_free(pa);
	pa=NULL;
	return 0;
}
