#include <string.h>
#include "seq_simple.h"
#include "wav_pulse.h"

#define TRACK_MAX 19


struct seq_simple_trstr{
	void *o; //Wav Obj
	Uint8  *p;//Data Position
	Uint8  n ;//Note  
	Uint32 c ;//Count(Data)
	Uint32 cn;//Count Note 
	Uint8 *lp;//Loop Position
	Uint32 lc;//Loop Count
	
	Uint32 vo;//Volume
	Uint32 gt;//GT
	Uint8  oc;//Octave
	Uint32 le;//Length
	Uint8  ns;//NoteShift
	Uint8  ti;//Tie
};
typedef struct seq_simple_trstr seq_simple_trobj;


Uint8 trackmax;
Uint32 tempo = 150*2;
Uint32 freq = 44100;
Uint32 tick = 480;
Uint32 spt;//Sample Per Tick
seq_simple_trobj tr[TRACK_MAX];

//                     a b  c d e f g
const Uint8 notetbl[]={9,11,0,2,4,5,7};


void* seq_simple_free(){
	Uint32 a;
	
	for(a=0;a<trackmax;a++){
		if(tr[a].o)wav_pulse_free(tr[a].o);
		tr[a].o = NULL;
	}
}

Uint8 seq_simple_init(Uint32 frq, Uint8 trackm){
	Uint32 a,b;
	seq_simple_trobj *ot;
	
	memset(tr,0,sizeof(seq_simple_trobj)*TRACK_MAX);

	freq = frq;
	trackmax = trackm;
	if(trackmax>TRACK_MAX)trackmax=TRACK_MAX;
	

	for(a=0;a<trackmax;a++){
		ot = wav_pulse_init(frq);
		if(!ot){return 1;}
		tr[a].o = ot;
	}
	return 0;
}

Uint8 seq_simple_read(Uint8 *str){
	Uint32 first=1,t=0;
	tempo=150*2;
	for(;*str && t<trackmax;str++){
		if(first){
			first=0;
			tr[t].p=str;
			tr[t].c=1;
			tr[t].cn=0;
			tr[t].lp=NULL;
			tr[t].lc=0;

			tr[t].vo=0x8;
			tr[t].gt=0;
			tr[t].oc=7;
			tr[t].ns=0;
			tr[t].le=tick/16;
			t++;
		}
		if(*str>='A' && *str<='Z') *str |= 0x20; 
		if(*str==';')first=1;
	}
	return 0;
}

Uint32 seq_simple_tick_per_render(){
	if(tempo<=0)return 1;
	if(freq<tempo)return 1;
	return freq / tempo;
}

Int32 seq_simple_render(){
	Uint32 t=0;
	Int32 o=0;
	for(t=0; t<trackmax; t++){
		if(tr[t].p){
			o+=wav_pulse_sample(tr[t].o);
		}
	}
	return o;
}

Uint8 seq_simple_tick(){
	Uint32 a,b,c,ct,t=0,ta=0;
	for(t=0; t<trackmax; t++){if(tr[t].p){
		if(tr[t].cn){
			if(!--tr[t].cn){
				wav_pulse_keyon(tr[t].o,tr[t].n,0);
			}
		}
		ta++;
		tr[t].c--;
		for(ct=0;ct<100&&(!tr[t].c)&&tr[t].p;ct++){
			c=*tr[t].p;tr[t].p++;
			switch(c){
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
				tr[t].n = tr[t].oc*12 + notetbl[c-'a'] + tr[t].ns;
				while(*tr[t].p=='+' || *tr[t].p=='-'){
					if(*tr[t].p=='+')tr[t].n++;
					if(*tr[t].p=='-')tr[t].n--;
					tr[t].p++;
				}
				wav_pulse_keyon(tr[t].o,tr[t].n,tr[t].vo);
				tr[t].c = str2len(&tr[t].p, tr[t].le, tick);
				if(*tr[t].p == '&'){//Tie
					tr[t].cn = tr[t].c ; tr[t].p++;
				}else{
					tr[t].cn = tr[t].c - tr[t].gt;
				}
				break;
			case 'r':
				wav_pulse_keyon(tr[t].o,0,0);
				tr[t].c = str2len(&tr[t].p, tr[t].le, tick);
				tr[t].cn = 0;
				break;
			case 'l':
				if(*tr[t].p!='+')a=0;else {tr[t].p++;a=tr[t].le;}
				a+=str2len(&tr[t].p, tr[t].le, tick);
				tr[t].le = a;
				break;
			case 'o':
				if(*tr[t].p!='+')a=0;else {tr[t].p++;a=tr[t].oc;}
				a+=str2num(&tr[t].p,SIGNED_DEC);
				tr[t].oc = a;
				break;
			case 'n':
				if(*tr[t].p!='+')a=0;else {tr[t].p++;a=tr[t].ns;}
				a+=str2num(&tr[t].p,SIGNED_DEC);
				tr[t].ns = a;
				break;
			case 'q':
				if(*tr[t].p!='+')a=0;else {tr[t].p++;a=tr[t].gt;}
				a+=str2num(&tr[t].p,SIGNED_DEC);
				tr[t].gt = a;
				break;
			case 't':
				if(*tr[t].p!='+')a=0;else {tr[t].p++;a=tempo/2;}
				a+=str2num(&tr[t].p,SIGNED_DEC);
				tempo = a*2;
				break;
			case 'v':
				if(*tr[t].p!='+')a=0;else {tr[t].p++;a=tr[t].vo;}
				a+=str2num(&tr[t].p,SIGNED_DEC);
				tr[t].vo = a;
				break;
			case '@':
				wav_pulse_setparam(tr[t].o,0,str2num(&tr[t].p,SIGNED_DEC));
				break;
			case '[':
				if((a=str2num(&tr[t].p,UNSIGNED_DEC))<2)
				     tr[t].lc = 1;
				else tr[t].lc = a-1;
				tr[t].lp = tr[t].p;
				break;
			case ']':
			    if(tr[t].lc && tr[t].lp){
					tr[t].lc--;
					if(!tr[t].lc){
						char *pb;
						pb=tr[t].p;
						tr[t].p = tr[t].lp;
						tr[t].lp= pb;
					}else{
						tr[t].p = tr[t].lp;
					}
				}else{
					tr[t].lp = NULL;
				}
				break;
			case '/':
			    if(!tr[t].lc && tr[t].lp){
					tr[t].p = tr[t].lp;
					tr[t].lp = NULL;
				}
				break;
			case '<':if(tr[t].oc<10)tr[t].oc++;break;
			case '>':if(tr[t].oc>0)tr[t].oc--;break;
			case 0:
			case ';':
				wav_pulse_keyon(tr[t].o,0,0);
				tr[t].p=NULL;
				break;
			}
		}
	}}
	return ta;
}
