#include "wav_pulse.h"
#include <stdlib.h>

struct wav_pulse_str{
	Uint32 freq; //Freq
	Uint32 notetbl[NOTEMAX];
	Uint8 note;
	Uint32 vol;
	Uint32 fr; //Freq Register
	Uint32 fa; //Freq Add
	Uint32 ev; //Envelope Value
	Uint32 es; //Envelope Speed
};
typedef struct wav_pulse_str wav_pulse_obj;

void* wav_pulse_init(Uint32 frq){
	Uint32 a,b;
	float fq;
	wav_pulse_obj *o;
	
	o = malloc(sizeof(wav_pulse_obj));
	if(!o)return NULL;
	
	//NoteFrq Calc
	o->freq = frq;
	fq=(280.0 * 0x8000000) / frq;
	for(a=1;a<NOTEMAX;a++){
		o->notetbl[a] = fq;
		fq *= NOTEMUL;
	}
	
	o->note=-1;
	o->vol=0x10;
	o->fr=0;
	o->es=0;
	
	return o;
}

void wav_pulse_keyon(void *object, Uint8 note, Uint8 vol){
	wav_pulse_obj *o = (wav_pulse_obj*)object;
	if(note>=128)o->fa=0;
	else o->fa = o->notetbl[note];
	if(!note)o->fr=0;
	o->vol = vol<<7;
	o->ev = 0x1000000;
}

void wav_pulse_setparam(void *object, Uint32 a, Uint32 v){
	wav_pulse_obj *o = (wav_pulse_obj*)object;
	if(a==0){
		if(v==0)o->es=0;
		else o->es = (0x80000000 / o->freq) / v;
	}
}

Int32 wav_pulse_sample(void *object){
	wav_pulse_obj *o = (wav_pulse_obj*)object;
	Int32 out = (o->vol * (o->ev >> 16))>>8;
	
	//Envelope
	if(o->ev <= o->es)o->ev=0;
	else o->ev -= o->es;
	
	if((o->fr&0x7fffffff)+o->fa >= 0x80000000){
		Int32 bb[2];Uint32 rb,ra;
		if(o->fr&0x80000000){
			bb[0]=-out;
			bb[1]=out;
		}else{
			bb[0]=out;
			bb[1]=-out;
		}
		rb = 0x80000000-(o->fr&0x7fffffff);
		o->fr += o->fa;
		ra = o->fa - rb;
		return divblend(bb,2,rb/(o->fa>>8),ra/(o->fa>>8)); 
	}else{
		o->fr += o->fa;
		if(o->fr>=0x80000000)return -out;
		else return out;
	}
}

void wav_pulse_free(void *object){
	free(object);
}
